XIncludeFile "export.pbi"

Procedure ExportRequester(file.s)
  If file
    If FindString(file, ".inc", 1) = 0
      file = file + ".inc"
    EndIf
    If FileSize(file) > 0
      If MessageRequester("Error", "File already exists. Replace it ?", #PB_MessageRequester_YesNo) = #PB_MessageRequester_Yes
        DeleteFile(file)
      Else
        ProcedureReturn
      EndIf
    EndIf
    ExportMap(file)
  EndIf
EndProcedure

Procedure ExportMap(file.s)
  Protected x.l, y.l, i.l = 0

  If OpenFile(0, "objects.asm") = 0
    MessageRequester("OpenFile() error", "Can't export objects.asm")
    ProcedureReturn
  EndIf
  WriteStringN(0, "brushes:")
  ForEach brushes()
    WriteStringN(0, Chr(9)+".dw brush"+RSet(Str(i), 3, "0"))
    i+1
  Next
  WriteStringN(0, "")
  i = 0
  ForEach brushes()
    WriteStringN(0, "brush"+RSet(Str(i), 3, "0")+":")
    WriteString(0, Chr(9)+".db %")
    If brushes()\interaction <> ""
      WriteString(0, "1")
    Else
      WriteString(0, "0")
    EndIf
    If brushes()\collision <> ""
      WriteString(0, "1")
    Else
      WriteString(0, "0")
    EndIf
    WriteString(0, "000") ; Currently unused (?)
    If brushes()\height > 0
      WriteString(0, "1")
    Else
      WriteString(0, "0")
    EndIf
    If brushes()\passable = 1
      WriteString(0, "1")
    Else
      WriteString(0, "0")
    EndIf
    If brushes()\animation = 1
      WriteStringN(0, "1")
    Else
      WriteStringN(0, "0")
    EndIf
    WriteString(0, Chr(9)+".db "+Str(brushes()\tile))
    If brushes()\animation = 1
      WriteStringN(0, Str(brushes()\offset))
    Else
      WriteStringN(0, "")
    EndIf
    If brushes()\masked = 1
      WriteStringN(0, Chr(9)+".db "+Str(brushes()\mask))
    EndIf
    If brushes()\height > 0
      WriteStringN(0, Chr(9)+".db "+Str(brushes()\height))
    EndIf
    If brushes()\interaction <> ""
      WriteStringN(0, brushes()\interaction)
    EndIf
    If brushes()\collision <> ""
      WriteStringN(0, brushes()\collision)
    EndIf
    i+1
  Next
  CloseFile(0)

  If OpenFile(0, "tiles.inc") = 0
    MessageRequester("OpenFile() error", "Can't export objects.asm")
    ProcedureReturn
  EndIf
  WriteStringN(0, "tiles:")
  If DatabaseQuery(#Database, "SELECT * FROM tile ORDER BY id;")
    While NextDatabaseRow(#Database)
      WriteStringN(0, "#include"+Chr(9)+Chr(34)+"tiles\"+GetDatabaseString(#Database, 1)+Chr(34))
    Wend
    FinishDatabaseQuery(#Database)
  Else
    MessageRequester("DatabaseUpdate() error", DatabaseError())
    End
  EndIf
  WriteStringN(0, "")
  
  If OpenFile(0, "masks.inc") = 0
    MessageRequester("OpenFile() error", "Can't export objects.asm")
    ProcedureReturn
  EndIf
  WriteStringN(0, "masks:")
  If DatabaseQuery(#Database, "SELECT * FROM mask ORDER BY id;")
    While NextDatabaseRow(#Database)
      WriteStringN(0, "#include"+Chr(9)+Chr(34)+"masks\"+GetDatabaseString(#Database, 1)+Chr(34))
    Wend
    FinishDatabaseQuery(#Database)
  Else
    MessageRequester("DatabaseUpdate() error", DatabaseError())
    End
  EndIf
  WriteStringN(0, "")

  If OpenFile(0, file) = 0
    MessageRequester("OpenFile() error", "Can't export map.")
    ProcedureReturn
  EndIf

  WriteStringN(0, map_\title+":")
  WriteStringN(0, Chr(9)+".db "+Str(map_\w)+","+Str(map_\h)+","+Str(map_\default_tile))
  For y=0 To map_\h-1
    WriteString(0, Chr(9)+".db ")
    For x=0 To map_\w-1
      WriteString(0, Str(map_data(x, y)\id))
      If x<>map_\w-1
        WriteString(0, ",")
      EndIf
    Next x
    WriteStringN(0, "")
  Next y

  CloseFile(0)
  sndPlaySound_("ding.wav", 0)
EndProcedure
; IDE Options = PureBasic 4.60 (Windows - x86)
; CursorPosition = 17
; Folding = -
; EnableXP
; UseMainFile = main.pb
; CurrentDirectory = ..\